#include <mqx.h>
#include <bsp.h>

#include <ltc2498spi.h>

//>>>>>>>>>>>>>>>>>>>>>>>>
//ltc2498spi.h
//ltc2498spi.c
//>>>>>>>>>>
//This file contains the send/receive functions for the LTC 2498 ADC
//The header file lists all the configuration options that can be passed in.
//


uint_32 send_receive_LTC2498 (uint_8 channel, uint_8 setting, FILE_PTR spifd)
{
   uint_32 param, output = 0x0000, result;
   SPI_READ_WRITE_STRUCT  rw;
   uint_16 temp_setting;
   uint_32 msw_msb; // Most significant word containing most significant byte
   uint_32 msw_lsb; // Most significant word containing least significant byte
   uint_32 lsw_msb; // Least significant word containing most significant byte
   uint_32 lsw_lsb; // Least significant word containing least significant byte
   
   //Set up the CHANNEL field, add mask (shift up)
   param = (LTC2498_CHANNEL_MASK | channel);
   
#if defined BSP_TWR_K60D100M
   // Reverse byte ordering for Kinetis   
   temp_setting = setting << 8;
#else   
   param = param << 8;
#endif
   
   //Configure the SETTING field (shift up)

#if defined BSP_TWR_K60D100M
   // Reverse byte ordering for Kinetis due to differences in endianness
   param = param | temp_setting;
#else   
   param = param | setting;
   param = param << 16;
#endif   
   
   
   rw.BUFFER_LENGTH = 4;
   rw.WRITE_BUFFER = (char*)&param;  //New compiler complains
   rw.READ_BUFFER = (char*)&output;
   //printf ("READ WRITE ... ");
   _time_delay(50);
   result = ioctl (spifd, IO_IOCTL_SPI_READ_WRITE, &rw);
   
   /* Fix for reading proper value */
#if defined BSP_TWR_K60D100M
// Re-order bytes when using Kinetis so that it displays correctly   
   msw_msb = (output & 0x000000ff) << 24;
   msw_lsb = (output & 0x0000ff00) << 8;
   lsw_msb = (output & 0x00ff0000) >> 8;
   lsw_lsb = (output & 0xff000000) >> 24;
   output = (msw_msb | msw_lsb | lsw_msb | lsw_lsb);
   
   msw_msb = (param & 0x000000ff) << 24;
   msw_lsb = (param & 0x0000ff00) << 8;
   lsw_msb = (param & 0x00ff0000) >> 8;
   lsw_lsb = (param & 0xff000000) >> 24;   
   param = (msw_msb | msw_lsb | lsw_msb | lsw_lsb);   
#endif   
   
   if (SPI_OK == result) 
   {
      //printf ("OK, sent: 0x%08x, received: 0x%08x or %d\n", param, output, output);
   } else {
      printf ("ERROR\n");
   }
   //fflush (spifd);
   
   return output;
}